/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.fairy;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.IYHDanmaku;
import dev.xkmc.youkaishomecoming.content.entity.fairy.FairyEntity;
import dev.xkmc.youkaishomecoming.content.entity.rumia.MoveAroundNestGoal;
import dev.xkmc.youkaishomecoming.content.entity.youkai.IYoukaiMerchant;
import dev.xkmc.youkaishomecoming.content.spell.game.TouhouSpellCards;
import dev.xkmc.youkaishomecoming.events.EffectEventHandlers;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import dev.xkmc.youkaishomecoming.init.data.YHTagGen;
import dev.xkmc.youkaishomecoming.init.food.YHFood;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import dev.xkmc.youkaishomecoming.init.registrate.YHItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class CirnoEntity
extends FairyEntity
implements IYoukaiMerchant {
    private MerchantOffers tradingOffers;
    private Player tradingPlayer;

    public static AttributeSupplier.Builder createAttributes() {
        return FairyEntity.createAttributes().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22281_, 6.0);
    }

    public CirnoEntity(EntityType<? extends CirnoEntity> type, Level level) {
        super((EntityType<? extends FairyEntity>)type, level);
        this.m_21530_();
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(6, (Goal)new MoveAroundNestGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(YHTagGen.FROZEN_FROG), false));
    }

    public boolean m_142079_() {
        return false;
    }

    @Override
    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || source.m_269533_(DamageTypeTags.f_268419_);
    }

    @Override
    protected boolean wouldAttack(LivingEntity entity) {
        return super.wouldAttack(entity) || entity instanceof Frog;
    }

    @Override
    public void onDanmakuHit(LivingEntity e, IYHDanmaku danmaku) {
        if (e.m_6844_(EquipmentSlot.HEAD).m_150930_(Items.f_42407_) && e.m_6844_(EquipmentSlot.CHEST).m_150930_(Items.f_42408_) && e.m_6844_(EquipmentSlot.LEGS).m_150930_(Items.f_42462_) && e.m_6844_(EquipmentSlot.FEET).m_150930_(Items.f_42463_)) {
            ItemStack ice = YHItems.FAIRY_ICE_CRYSTAL.asStack();
            double chance = (Double)YHModConfig.COMMON.cirnoFairyDrop.get();
            if (e.m_217043_().m_188500_() < chance) {
                if (e instanceof Player) {
                    Player pl = (Player)e;
                    pl.m_150109_().m_150079_(ice);
                } else {
                    e.m_19983_(ice);
                }
            }
            return;
        }
        if (EffectEventHandlers.isFullCharacter(e)) {
            return;
        }
        e.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 2));
        if (e.m_142079_()) {
            e.m_146917_(Math.min(200, e.m_146888_() + 120));
        }
    }

    @Override
    public void initSpellCard() {
        TouhouSpellCards.setCirno(this);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance diff, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag nbt) {
        if (reason == MobSpawnType.NATURAL || reason == MobSpawnType.STRUCTURE) {
            this.m_21446_(this.m_20183_(), 8);
        }
        return super.m_6518_(level, diff, reason, data, nbt);
    }

    public static boolean checkCirnoSpawnRules(EntityType<CirnoEntity> e, ServerLevelAccessor level, MobSpawnType type, BlockPos pos, RandomSource rand) {
        return CirnoEntity.m_217057_(e, (LevelAccessor)level, (MobSpawnType)type, (BlockPos)pos, (RandomSource)rand) && (Boolean)YHModConfig.COMMON.cirnoSpawn.get() != false && level.m_45976_(CirnoEntity.class, AABB.m_165882_((Vec3)pos.m_252807_(), (double)48.0, (double)24.0, (double)48.0)).isEmpty();
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_5912_()) {
            return InteractionResult.PASS;
        }
        if (!EffectEventHandlers.isCharacter((LivingEntity)player) && !player.m_21120_(hand).m_204117_(YHTagGen.FROZEN_FROG)) {
            return InteractionResult.PASS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.openMenu((Player)sp);
        }
        return InteractionResult.SUCCESS;
    }

    public void openMenu(Player player) {
        if (this.m_7962_() != null && this.m_7962_().m_6084_()) {
            return;
        }
        this.tradingOffers = null;
        this.init(player);
        this.m_45301_(player, this.m_7755_(), 0);
    }

    private Item getWantedItem() {
        Holder holder = this.m_9236_().m_204166_(this.m_20183_());
        long day = this.m_9236_().m_46467_() / 24000L;
        double rand = RandomSource.m_216335_((long)RandomSource.m_216335_((long)day).m_188505_()).m_188500_();
        if (holder.m_203656_(BiomeTags.f_215808_)) {
            return rand < 0.3 ? (Item)YHItems.FROZEN_FROG_TEMPERATE.get() : (Item)YHItems.FROZEN_FROG_WARM.get();
        }
        if (holder.m_203656_(BiomeTags.f_215809_)) {
            return rand < 0.3 ? (Item)YHItems.FROZEN_FROG_TEMPERATE.get() : (Item)YHItems.FROZEN_FROG_COLD.get();
        }
        return rand < 0.5 ? (Item)YHItems.FROZEN_FROG_WARM.get() : (Item)YHItems.FROZEN_FROG_COLD.get();
    }

    private MerchantOffers getOfferList() {
        MerchantOffers ans = new MerchantOffers();
        Item item = this.getWantedItem();
        ans.add((Object)CirnoEntity.offer((Item)YHFood.CANDY_APPLE.item.get(), 4, YHFood.FAIRY_CANDY.item.asStack()));
        ans.add((Object)CirnoEntity.offer(item, 1, YHItems.FAIRY_ICE_CRYSTAL.asStack()));
        ans.add((Object)CirnoEntity.offer(item, 1, YHItems.ICE_CUBE.asStack(64)));
        ans.add((Object)CirnoEntity.offer(item, 1, YHDanmaku.Bullet.CIRCLE.get(DyeColor.CYAN).asStack(8)));
        ans.add((Object)CirnoEntity.offer(item, 1, YHDanmaku.Bullet.BALL.get(DyeColor.CYAN).asStack(8)));
        ans.add((Object)CirnoEntity.offer(item, 1, YHDanmaku.Bullet.MENTOS.get(DyeColor.CYAN).asStack(4)));
        if (!this.getFlag(4)) {
            ans.add((Object)new MerchantOffer(new ItemStack((ItemLike)item, 16), YHItems.CIRNO_HAIRBAND.asStack(), 1, 0, 0.0f));
        }
        return ans;
    }

    private static MerchantOffer offer(Item in, int a, ItemStack b) {
        return new MerchantOffer(new ItemStack((ItemLike)in, a), b, 64, 0, 0.0f);
    }

    public void m_7189_(@Nullable Player player) {
        this.tradingPlayer = player;
    }

    @Nullable
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    public MerchantOffers m_6616_() {
        if (this.tradingOffers == null) {
            this.tradingOffers = this.getOfferList();
        }
        return this.tradingOffers;
    }

    public void m_6255_(MerchantOffers offers) {
        this.tradingOffers = offers;
    }

    @Override
    public void m_6996_(MerchantOffer offer) {
        IYoukaiMerchant.super.m_6996_(offer);
        if (offer.m_45368_().m_150930_((Item)YHItems.CIRNO_HAIRBAND.get())) {
            this.setFlag(4, true);
        }
    }
}

